(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    120721,       2514]
NotebookOptionsPosition[    120200,       2496]
NotebookOutlinePosition[    120629,       2513]
CellTagsIndexPosition[    120586,       2510]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"System`Graph", "[", 
       RowBox[{
        RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
        RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
        RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
      RowBox[{"Valencias", "[", 
       RowBox[{"System`Graph", "[", 
        RowBox[{
         RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
         RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
         RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}], ",", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<Cantidad de aristas: \>\"", ",", 
         RowBox[{"EdgeCount", "[", 
          RowBox[{"System`Graph", "[", 
           RowBox[{
            RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
            RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
            RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}], ",", 
         "\"\< = \>\"", ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"FactorInteger", "[", 
              RowBox[{"EdgeCount", "[", 
               RowBox[{"System`Graph", "[", 
                RowBox[{
                 RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
                 RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                 RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}], 
              "]"}], "]"}], "\[Equal]", "1"}], ",", 
           RowBox[{
            RowBox[{"GVl55", "=", 
             RowBox[{"Superscript", "@@@", 
              RowBox[{"FactorInteger", "[", 
               RowBox[{"EdgeCount", "[", 
                RowBox[{"System`Graph", "[", 
                 RowBox[{
                  RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
                  RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                  RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}], 
               "]"}]}]}], ";", 
            RowBox[{"GVl55", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"CenterDot", "@@", 
            RowBox[{"(", 
             RowBox[{"Superscript", "@@@", 
              RowBox[{"FactorInteger", "[", 
               RowBox[{"EdgeCount", "[", 
                RowBox[{"System`Graph", "[", 
                 RowBox[{
                  RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
                  RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                  RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}], 
               "]"}]}], ")"}]}]}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<Tiene circuitos de Euler: \>\"", ",", 
         RowBox[{"EulerianGraphQ", "[", 
          RowBox[{"System`Graph", "[", 
           RowBox[{
            RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
            RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
            RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}]}], 
        "}"}], "]"}], ",", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<Tiene circuitos de Hamilton: \>\"", ",", 
         RowBox[{"HamiltonianGraphQ", "[", 
          RowBox[{"System`Graph", "[", 
           RowBox[{
            RowBox[{"GraphData", "[", "GVl54", "]"}], ",", 
            RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
            RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], "]"}]}], 
        "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "GVl54", ",", "\"\<ChvatalGraph\>\"", ",", "\"\<Tipo de grafo\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ChvatalGraph\>\"", ",", "\"\<CubicalGraph\>\"", ",", 
       "\"\<DodecahedralGraph\>\"", ",", "\"\<FranklinGraph\>\"", ",", 
       "\"\<FruchtGraph\>\"", ",", "\"\<GroetzschGraph\>\"", ",", " ", 
       "\"\<HeawoodGraph\>\"", ",", "\"\<HerschelGraph\>\"", ",", 
       "\"\<IcosahedralGraph\>\"", ",", "\"\<LeviGraph\>\"", ",", 
       "\"\<McGeeGraph\>\"", ",", "\"\<NoPerfectMatchingGraph\>\"", ",", 
       "\"\<OctahedralGraph\>\"", ",", "\"\<PetersenGraph\>\"", ",", 
       "\"\<RobertsonGraph\>\"", ",", "\"\<SmallestCyclicGroupGraph\>\"", 
       ",", "\"\<TetrahedralGraph\>\"", ",", "\"\<TutteGraph\>\"", ",", 
       "\"\<UniquelyThreeColorableGraph\>\"", ",", "\"\<WaltherGraph\>\""}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Valencias", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "GGrafoAuxiliar15", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"GGrafoAuxiliar15", "=", 
               RowBox[{"Grafo", "[", 
                RowBox[{
                 RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], ",", 
                 RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                 RowBox[{"vertices", "\[Rule]", 
                  RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "]"}]}], 
              ";", 
              RowBox[{"TableForm", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"VertexInDegree", "[", "GGrafoAuxiliar15", "]"}], 
                  ",", 
                  RowBox[{"VertexOutDegree", "[", "GGrafoAuxiliar15", "]"}]}],
                  "}"}], ",", 
                RowBox[{"TableHeadings", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<Grado o valencia interna\>\"", ",", 
                    "\"\<Grado o valencia externa\>\""}], "}"}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar15", "]"}]}]}], 
                  "}"}]}], ",", 
                RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}]}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedGraphQ", "[", "GGrafo", "]"}], ",", 
               RowBox[{"TableForm", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"VertexDegree", "[", "GGrafo", "]"}], "}"}], ",", 
                 RowBox[{"TableHeadings", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", "\"\<Grado o valencia\>\"", "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "}"}]}], 
                 ",", 
                 RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}], 
               ",", 
               RowBox[{"TableForm", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"VertexInDegree", "[", "GGrafo", "]"}], ",", 
                   RowBox[{"VertexOutDegree", "[", "GGrafo", "]"}]}], "}"}], 
                 ",", 
                 RowBox[{"TableHeadings", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Grado o valencia interna\>\"", ",", 
                    "\"\<Grado o valencia externa\>\""}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "}"}]}], 
                 ",", 
                 RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}]}], 
              "]"}]}], "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"GGrafoAuxiliar15", "=", 
               RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], ";", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"UndirectedGraphQ", "[", "GGrafoAuxiliar15", "]"}], 
                ",", 
                RowBox[{"TableForm", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"VertexDegree", "[", "GGrafoAuxiliar15", "]"}], 
                   "}"}], ",", 
                  RowBox[{"TableHeadings", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", "\"\<Grado o valencia\>\"", "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar15", "]"}]}]}], 
                    "}"}]}], ",", 
                  RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}], 
                ",", 
                RowBox[{"TableForm", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"VertexInDegree", "[", "GGrafoAuxiliar15", "]"}], 
                    ",", 
                    RowBox[{
                    "VertexOutDegree", "[", "GGrafoAuxiliar15", "]"}]}], 
                   "}"}], ",", 
                  RowBox[{"TableHeadings", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<Grado o valencia interna\>\"", ",", 
                    "\"\<Grado o valencia externa\>\""}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar15", "]"}]}]}], 
                    "}"}]}], ",", 
                  RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], "]"}]}],
                "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"AristasMixtasQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"DirectedEdge", "[", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                 "#"}], "&"}]}], "]"}], "\[NotEqual]", 
             RowBox[{"{", "}"}]}], "&&", 
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"UndirectedEdge", "[", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                 "#"}], "&"}]}], "]"}], "\[NotEqual]", 
             RowBox[{"{", "}"}]}]}], ",", "True", ",", "False"}], "]"}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{
       "AristasMixtasWolframSystemToCombinatorica", "[", "GAristasGrafo_", 
        "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar10", "=", 
           RowBox[{"System`Graph", "[", "GAristasGrafo", "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GraphQ", "[", "GGrafoAuxiliar10", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafoAuxiliar10", "]"}], ",", 
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                RowBox[{"Select", "[", 
                 RowBox[{
                  RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"DirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", 
               RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                RowBox[{"Select", "[", 
                 RowBox[{
                  RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", 
               RowBox[{"Reverse", "[", 
                RowBox[{
                 RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                  RowBox[{"Select", "[", 
                   RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", "2"}], "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GraphQ", "[", "GGrafo", "]"}], ",", "True", ",", "False"}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoCQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumericQ", "[", 
          RowBox[{"V", "[", "GGrafo", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"V", "[", "GGrafo", "]"}], "\[Equal]", "0"}], ",", 
           "False", ",", "True"}], "]"}], ",", "False"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{
       "AristasWolframSystemToCombinatorica", "[", "GAristasGrafo_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar1", "=", 
           RowBox[{"System`Graph", "[", "GAristasGrafo", "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GraphQ", "[", "GGrafoAuxiliar1", "]"}], ",", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GAristasGrafo", ",", 
              RowBox[{"Gicontador1_", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Gicontador1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador1", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "]"}], "]"}]}],
           "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "CombinatoricaToGraph", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CombinatoricaToGraph", "[", 
        RowBox[{"GGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GrafoO3d", ",", "GrafoONo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GrafoO3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoONo3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                RowBox[{"GrafoO3d", "[", "GGrafo", "]"}], ",", 
                RowBox[{"GrafoONo3d", "[", "GGrafo", "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "Grafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
         RowBox[{"vertices", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"pesos", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"Grafo", "[", 
        RowBox[{"GAristas_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "GAristasNoDirigidas", ",", "GAristasDirigidas", ",", 
           "GLabelsPesos", ",", "Grafo3d", ",", "GrafoNo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador4_", "\[Rule]", 
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador5_", "\[Rule]", 
               RowBox[{"DirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GLabelsPesos", "[", 
            RowBox[{"GGrafo_", ",", "GPesos_"}], "]"}], ":=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "GPesos", "]"}], "\[Equal]", 
              RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GList1", "=", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], ",", 
                 RowBox[{"GList2", "=", 
                  RowBox[{"{", "}"}]}]}], "}"}], ",", 
               RowBox[{
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"Gi1", "=", "1"}], ",", 
                  RowBox[{"Gi1", "\[LessEqual]", 
                   RowBox[{"Length", "[", "GList1", "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"GList2", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"GList2", ",", 
                    RowBox[{
                    RowBox[{"GList1", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}], "\[Rule]", 
                    RowBox[{"GPesos", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}]}]}], "]"}]}], ";", 
                   RowBox[{"Gi1", "++"}]}]}], "]"}], ";", "GList2"}]}], 
              "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"Grafo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoNo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                  "Null"}], "]"}], "\[Equal]", "False"}], "&&", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}], 
                 "]"}], "\[Equal]", "False"}]}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MatrixQ", "[", "GAristas", "]"}], "||", 
                   RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "&&", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", "GAristas", "]"}], ",", "Null"}], 
                   "]"}], "\[Equal]", "False"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                   RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MatrixQ", "[", "GAristas", "]"}], "&&", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "GAristas", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GAristas", "]"}], "]"}], ",", 
                    "62760"}], "]"}], "\[Equal]", "False"}]}], ")"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                    RowBox[{"Grafo3d", "[", "GAristas", "]"}], ",", 
                    RowBox[{"GrafoNo3d", "[", "GAristas", "]"}]}], "]"}]}], 
                   "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"PesosAristas", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"WeightedGraphQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", 
                  RowBox[{"Quiet", "[", 
                   RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"Gicontador6_", "\[Rule]", " ", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
                  "]"}], "\[Equal]", 
                 RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
                RowBox[{"GList3", "=", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Gi2", ",", "1", ",", 
                    RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], 
                  "]"}]}]}], "]"}], ";", 
              RowBox[{"GList4", "=", 
               RowBox[{"Select", "[", 
                RowBox[{"GList3", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"DirectedEdge", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
              RowBox[{"GList5", "=", 
               RowBox[{
                RowBox[{"Select", "[", 
                 RowBox[{"GList3", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}], "/.", 
                RowBox[{"UndirectedEdge", "\[Rule]", "DirectedEdge"}]}]}], 
              ";", 
              RowBox[{"Join", "[", 
               RowBox[{"GList4", ",", "GList5", ",", 
                RowBox[{"Reverse", "[", 
                 RowBox[{"GList5", ",", "3"}], "]"}]}], "]"}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", 
                 RowBox[{"Quiet", "[", 
                  RowBox[{"Cases", "[", 
                   RowBox[{
                    RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"Gicontador6_", "\[Rule]", " ", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
                 "]"}], "\[Equal]", 
                RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
                   RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Gi2", ",", "1", ",", 
                   RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], 
                "]"}]}], "]"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ListQ", "[", 
              RowBox[{"Edges", "[", 
               RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}], "]"}], ",", 
             RowBox[{"DeleteDuplicates", "[", 
              RowBox[{"Edges", "[", 
               RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}], "]"}]}], "]"}]}],
           "]"}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Tipos especiales de grafos\>\"", ",", " ", "Bold", ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6715390268743763`*^9, 3.6715390300746355`*^9}, {
   3.6715417449848413`*^9, 3.671541757680106*^9}, {3.671541798913625*^9, 
   3.671541816166751*^9}, {3.6715418520463676`*^9, 3.6715418772097716`*^9}, {
   3.6715419135765195`*^9, 3.6715419621701756`*^9}, {3.6715420715502124`*^9, 
   3.671542074374511*^9}, 3.6715421706657596`*^9, {3.6715423271885242`*^9, 
   3.6715423275974894`*^9}, {3.6715423843497467`*^9, 
   3.6715423870461845`*^9}, {3.8011558122368155`*^9, 3.801155823472873*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"c50953d7-9429-4dfe-b87b-9cae9c055315"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`GVl54$$ = "ChvatalGraph", Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[$CellContext`GVl54$$], "ChvatalGraph", "Tipo de grafo"}, {
      "ChvatalGraph", "CubicalGraph", "DodecahedralGraph", "FranklinGraph", 
       "FruchtGraph", "GroetzschGraph", "HeawoodGraph", "HerschelGraph", 
       "IcosahedralGraph", "LeviGraph", "McGeeGraph", 
       "NoPerfectMatchingGraph", "OctahedralGraph", "PetersenGraph", 
       "RobertsonGraph", "SmallestCyclicGroupGraph", "TetrahedralGraph", 
       "TutteGraph", "UniquelyThreeColorableGraph", "WaltherGraph"}}}, 
    Typeset`size$$ = {835., {194., 203.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`GVl54$$ = "ChvatalGraph"}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Graph[
          GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
          ImagePadding -> 10], 
         $CellContext`Valencias[
          Graph[
           GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
           ImagePadding -> 10]], 
         Row[{"Cantidad de aristas: ", 
           EdgeCount[
            Graph[
             GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
             ImagePadding -> 10]], " = ", 
           If[Length[
              FactorInteger[
               EdgeCount[
                Graph[
                 GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
                 ImagePadding -> 10]]]] == 
            1, $CellContext`GVl55 = Apply[Superscript, 
               FactorInteger[
                EdgeCount[
                 Graph[
                  GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
                  ImagePadding -> 10]]], {1}]; Part[$CellContext`GVl55, 1], 
            Apply[CenterDot, 
             Apply[Superscript, 
              FactorInteger[
               EdgeCount[
                Graph[
                 GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
                 ImagePadding -> 10]]], {1}]]]}], 
         Row[{"Tiene circuitos de Euler: ", 
           EulerianGraphQ[
            Graph[
             GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
             ImagePadding -> 10]]}], 
         Row[{"Tiene circuitos de Hamilton: ", 
           HamiltonianGraphQ[
            Graph[
             GraphData[$CellContext`GVl54$$], VertexLabels -> "Name", 
             ImagePadding -> 10]]}]}], 
      "Specifications" :> {{{$CellContext`GVl54$$, "ChvatalGraph", 
          "Tipo de grafo"}, {
         "ChvatalGraph", "CubicalGraph", "DodecahedralGraph", "FranklinGraph",
           "FruchtGraph", "GroetzschGraph", "HeawoodGraph", "HerschelGraph", 
          "IcosahedralGraph", "LeviGraph", "McGeeGraph", 
          "NoPerfectMatchingGraph", "OctahedralGraph", "PetersenGraph", 
          "RobertsonGraph", "SmallestCyclicGroupGraph", "TetrahedralGraph", 
          "TutteGraph", "UniquelyThreeColorableGraph", "WaltherGraph"}}}, 
      "Options" :> {FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["Tipos especiales de grafos", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{907., {315., 324.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`Valencias[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := Module[{$CellContext`GGrafoAuxiliar15}, 
         If[
          $CellContext`GrafoQ[$CellContext`GGrafo], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar15 = $CellContext`Grafo[
              $CellContext`AristasMixtasWolframSystemToCombinatorica[
               EdgeList[$CellContext`GGrafo]], $CellContext`dirigido -> 
              True, $CellContext`vertices -> VertexList[$CellContext`GGrafo]]; 
           TableForm[{
              VertexInDegree[$CellContext`GGrafoAuxiliar15], 
              VertexOutDegree[$CellContext`GGrafoAuxiliar15]}, 
             TableHeadings -> {{
               "Grado o valencia interna", "Grado o valencia externa"}, 
               Map[Style[#, Black]& , 
                VertexList[$CellContext`GGrafoAuxiliar15]]}, TableAlignments -> 
             Center], 
           If[
            UndirectedGraphQ[$CellContext`GGrafo], 
            TableForm[{
              VertexDegree[$CellContext`GGrafo]}, 
             TableHeadings -> {{"Grado o valencia"}, 
               Map[Style[#, Black]& , 
                VertexList[$CellContext`GGrafo]]}, TableAlignments -> Center], 
            TableForm[{
              VertexInDegree[$CellContext`GGrafo], 
              VertexOutDegree[$CellContext`GGrafo]}, 
             TableHeadings -> {{
               "Grado o valencia interna", "Grado o valencia externa"}, 
               Map[Style[#, Black]& , 
                VertexList[$CellContext`GGrafo]]}, TableAlignments -> 
             Center]]], 
          If[
           $CellContext`GrafoCQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar15 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[
             UndirectedGraphQ[$CellContext`GGrafoAuxiliar15], 
             TableForm[{
               VertexDegree[$CellContext`GGrafoAuxiliar15]}, 
              TableHeadings -> {{"Grado o valencia"}, 
                Map[Style[#, Black]& , 
                 VertexList[$CellContext`GGrafoAuxiliar15]]}, TableAlignments -> 
              Center], 
             TableForm[{
               VertexInDegree[$CellContext`GGrafoAuxiliar15], 
               VertexOutDegree[$CellContext`GGrafoAuxiliar15]}, 
              TableHeadings -> {{
                "Grado o valencia interna", "Grado o valencia externa"}, 
                Map[Style[#, Black]& , 
                 VertexList[$CellContext`GGrafoAuxiliar15]]}, TableAlignments -> 
              Center]]]]]; $CellContext`AristasMixtasQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          And[Select[
             EdgeList[$CellContext`GGrafo], DirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}, Select[
             EdgeList[$CellContext`GGrafo], UndirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}], True, 
          False]]; $CellContext`AristasMixtasWolframSystemToCombinatorica[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]]] := 
       Module[{$CellContext`GGrafoAuxiliar10 = 
          Graph[$CellContext`GAristasGrafo]}, 
         If[
          GraphQ[$CellContext`GGrafoAuxiliar10], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafoAuxiliar10], 
           Join[
            $CellContext`AristasWolframSystemToCombinatorica[
             Select[
              EdgeList[$CellContext`GGrafoAuxiliar10], DirectedEdge[
                Part[#, 1], 
                Part[#, 2]] == #& ]], 
            $CellContext`AristasWolframSystemToCombinatorica[
             Select[
              EdgeList[$CellContext`GGrafoAuxiliar10], UndirectedEdge[
                Part[#, 1], 
                Part[#, 2]] == #& ]], 
            Reverse[
             $CellContext`AristasWolframSystemToCombinatorica[
              Select[
               EdgeList[$CellContext`GGrafoAuxiliar10], UndirectedEdge[
                 Part[#, 1], 
                 Part[#, 2]] == #& ]], 2]]]]]; $CellContext`GrafoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         GraphQ[$CellContext`GGrafo], True, False]; $CellContext`GrafoCQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         NumericQ[
          $CellContext`V[$CellContext`GGrafo]], 
         If[$CellContext`V[$CellContext`GGrafo] == 0, False, True], 
         False]; $CellContext`AristasWolframSystemToCombinatorica[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]]] := 
       Module[{$CellContext`GGrafoAuxiliar1 = 
          Graph[$CellContext`GAristasGrafo]}, 
         If[
          GraphQ[$CellContext`GGrafoAuxiliar1], 
          Quiet[
           Cases[$CellContext`GAristasGrafo, Pattern[$CellContext`Gicontador1, 
              Blank[]] -> {
              Part[$CellContext`Gicontador1, 1], 
              Part[$CellContext`Gicontador1, 2]}]]]]; 
      Options[$CellContext`CombinatoricaToGraph] = {$CellContext`dimensions3d -> 
         False, $CellContext`mostrarpesos -> False, $CellContext`shape -> 
         False}; $CellContext`CombinatoricaToGraph[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GrafoO3d, $CellContext`GrafoONo3d}, \
$CellContext`GrafoO3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; $CellContext`GrafoONo3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            $CellContext`GrafoCQ[$CellContext`GGrafo], 
            If[
             OptionValue[$CellContext`dimensions3d], 
             $CellContext`GrafoO3d[$CellContext`GGrafo], 
             $CellContext`GrafoONo3d[$CellContext`GGrafo]]]]]; 
      Options[$CellContext`Grafo] = {$CellContext`dirigido -> 
         False, $CellContext`vertices -> {}, $CellContext`dimensions3d -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> False}; $CellContext`Grafo[
         Pattern[$CellContext`GAristas, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas, $CellContext`GLabelsPesos, \
$CellContext`Grafo3d, $CellContext`GrafoNo3d}, \
$CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador4, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador4, 1], 
               
               Part[$CellContext`Gicontador4, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador5, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador5, 1], 
               Part[$CellContext`Gicontador5, 2]]]]; $CellContext`GLabelsPesos[
            Pattern[$CellContext`GGrafo, 
             Blank[]], 
            Pattern[$CellContext`GPesos, 
             Blank[]]] := 
          If[Length[$CellContext`GPesos] == EdgeCount[$CellContext`GGrafo], 
            
            Module[{$CellContext`GList1 = 
              EdgeList[$CellContext`GGrafo], $CellContext`GList2 = {}}, 
             For[$CellContext`Gi1 = 1, $CellContext`Gi1 <= 
               Length[$CellContext`GList1], $CellContext`GList2 = 
                Append[$CellContext`GList2, 
                  Part[$CellContext`GList1, $CellContext`Gi1] -> 
                  Part[$CellContext`GPesos, $CellContext`Gi1]]; 
               Increment[$CellContext`Gi1]]; $CellContext`GList2]]; \
$CellContext`Grafo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; $CellContext`GrafoNo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`vertices]], 
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            And[MemberQ[
               OptionValue[$CellContext`vertices], Null] == False, MemberQ[
               OptionValue[$CellContext`pesos], Null] == False], 
            If[
             And[
              Or[
               MatrixQ[$CellContext`GAristas], 
               ToString[$CellContext`GAristas] == ToString[{}]], MemberQ[
                Flatten[$CellContext`GAristas], Null] == False], 
             If[
              Or[Length[$CellContext`GAristas] == Length[
                 OptionValue[$CellContext`pesos]], 
               OptionValue[$CellContext`pesos] == {}], 
              If[
               Or[
                And[
                ToString[$CellContext`GAristas] == ToString[{}], 
                 OptionValue[$CellContext`vertices] != {}], 
                And[
                 MatrixQ[$CellContext`GAristas], Part[
                   Dimensions[$CellContext`GAristas], 2] == 2, MemberQ[
                   ToCharacterCode[
                    ToString[$CellContext`GAristas]], 62760] == False]], 
               If[
                OptionValue[$CellContext`dimensions3d], 
                $CellContext`Grafo3d[$CellContext`GAristas], 
                $CellContext`GrafoNo3d[$CellContext`GAristas]]]]]]]]; \
$CellContext`PesosAristas[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          WeightedGraphQ[$CellContext`GGrafo], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafo], If[Length[
               Quiet[
                Cases[
                 EdgeList[$CellContext`GGrafo], 
                 Pattern[$CellContext`Gicontador6, 
                   Blank[]] -> NumericQ[
                   
                   PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == 
             EdgeCount[$CellContext`GGrafo], $CellContext`GList3 = Table[{
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
                PropertyValue[{$CellContext`GGrafo, 
                  Part[
                   EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
                 EdgeWeight]}, {$CellContext`Gi2, 1, 
                EdgeCount[$CellContext`GGrafo]}]]; $CellContext`GList4 = 
            Select[$CellContext`GList3, DirectedEdge[
                Part[
                 Part[#, 1], 1], 
                Part[
                 Part[#, 1], 2]] == Part[#, 1]& ]; $CellContext`GList5 = 
            ReplaceAll[
              Select[$CellContext`GList3, UndirectedEdge[
                 Part[
                  Part[#, 1], 1], 
                 Part[
                  Part[#, 1], 2]] == Part[#, 1]& ], UndirectedEdge -> 
              DirectedEdge]; Join[$CellContext`GList4, $CellContext`GList5, 
             Reverse[$CellContext`GList5, 3]], 
           If[Length[
              Quiet[
               Cases[
                EdgeList[$CellContext`GGrafo], 
                Pattern[$CellContext`Gicontador6, 
                  Blank[]] -> NumericQ[
                  
                  PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == EdgeCount[$CellContext`GGrafo], 
            Table[{
              Part[
               EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
              PropertyValue[{$CellContext`GGrafo, 
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
               EdgeWeight]}, {$CellContext`Gi2, 1, 
              EdgeCount[$CellContext`GGrafo]}]]]], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           ListQ[
            $CellContext`Edges[$CellContext`GGrafo, EdgeWeight]], 
           DeleteDuplicates[
            $CellContext`Edges[$CellContext`GGrafo, EdgeWeight]]]]]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.671542370819455*^9, 3.6715424127768583`*^9, 3.6715425056011558`*^9, {
   3.801156733453538*^9, 3.801156757453534*^9}},
 CellLabel->"Out[2]=",ExpressionUUID->"da1b8eda-865b-4d99-a25c-997ac00fa067"]
}, Open  ]]
},
WindowSize->{1350, 669},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f0d3a64a-02fe-49df-9f46-ca993c5e5580"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 80216, 1658, 13415, "Input",ExpressionUUID->"c50953d7-9429-4dfe-b87b-9cae9c055315"],
Cell[80799, 1682, 39385, 811, 667, "Output",ExpressionUUID->"da1b8eda-865b-4d99-a25c-997ac00fa067"]
}, Open  ]]
}
]
*)

